// TODO: revert tag hide-menu to show menu
define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/page/header/header.html',
], function(_, Backbone, Marionette, template) {
    'use strict';

    return Backbone.Marionette.View.extend({
        template: _.template(template),
        events: {
            'click #menu-btn, #user-menu-btn': 'togglePanel',
            'keydown #menu-btn, #user-menu-btn': 'handlePanelTab',
        },
        onRender: function () {
            this.mapPanelsToButtons();
        },
        onClose: function() {
            delete this.associatedPanel;
        },
        mapPanelsToButtons: function () {
            this.associatedPanel = {
                // 'menu-btn': $('#menu'),
                'user-menu-btn': $('#user-menu'),
            };
        },
        togglePanel: function (e) {
            var $panel = this.associatedPanel[e.currentTarget.id];

            $panel.panel('toggle');
        },
        handlePanelTab: function (e) {
            var $panel = this.associatedPanel[e.currentTarget.id];
            var $panelButtons = $panel.find('a, button');
            var tabKeyCode = 9;

            if ($panel.hasClass('ui-panel-open') && e.which === tabKeyCode) {
                e.preventDefault();
                $panelButtons.eq(e.shiftKey ? -1 : 0).focus();
            }
        },
    });
});
